/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.session;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.Destroyable;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.PrivilegedCode;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalSearchGuardSessionAuthenticationBackend
implements AuthenticationBackend,
Destroyable {
    private static final Logger log = LogManager.getLogger(ExternalSearchGuardSessionAuthenticationBackend.class);
    private final ComponentState componentState = new ComponentState(0, "authentication_backend", "external_session", ExternalSearchGuardSessionAuthenticationBackend.class).initialized().requiresEnterpriseLicense();
    private final ImmutableList<HttpHost> hosts;
    private final TLSConfig tlsConfig;
    private final ProxyConfig proxyConfig;
    private final int maxConnectionsPerHost;
    private PoolingHttpClientConnectionManager connectionManager;
    private CloseableHttpClient httpClient;
    private Thread idleConnectionMonitorThread;
    public static final String TYPE = "external_session";
    public static TypedComponent.Info<AuthenticationBackend> INFO = new TypedComponent.Info<AuthenticationBackend>(){

        public Class<AuthenticationBackend> getType() {
            return AuthenticationBackend.class;
        }

        public String getName() {
            return ExternalSearchGuardSessionAuthenticationBackend.TYPE;
        }

        public TypedComponent.Factory<AuthenticationBackend> getFactory() {
            return ExternalSearchGuardSessionAuthenticationBackend::new;
        }
    };

    public ExternalSearchGuardSessionAuthenticationBackend(Map<String, Object> config, ConfigurationRepository.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors, (Parser.Context)context);
        ImmutableList hostUris = vNode.get("hosts").required().asList().minElements(1).ofURIs();
        this.tlsConfig = (TLSConfig)vNode.get("tls").by(TLSConfig::parse);
        this.proxyConfig = (ProxyConfig)vNode.get("proxy").by(ProxyConfig::parse);
        this.maxConnectionsPerHost = vNode.get("connection_pool.max_connections_per_host").withDefault((Number)6).asInt();
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        this.hosts = hostUris.map(uri -> new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()));
        if (this.tlsConfig != null) {
            Registry connectionSocketFactoryRegistry = RegistryBuilder.create().register("https", (Object)this.tlsConfig.toSSLConnectionSocketFactory()).build();
            this.connectionManager = new PoolingHttpClientConnectionManager(connectionSocketFactoryRegistry);
        } else {
            this.connectionManager = new PoolingHttpClientConnectionManager();
        }
        this.connectionManager.setMaxTotal(this.maxConnectionsPerHost * this.hosts.size());
        this.connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerHost);
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(builder);
        }
        this.httpClient = builder.build();
        this.idleConnectionMonitorThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (ExternalSearchGuardSessionAuthenticationBackend.this.connectionManager != null) {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            this.wait(5000L);
                            if (ExternalSearchGuardSessionAuthenticationBackend.this.connectionManager != null) {
                                ExternalSearchGuardSessionAuthenticationBackend.this.connectionManager.closeExpiredConnections();
                                ExternalSearchGuardSessionAuthenticationBackend.this.connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                            }
                        }
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    public CompletableFuture<AuthCredentials> authenticate(AuthCredentials authCredentials, Meter meter) throws AuthenticatorUnavailableException, CredentialsException {
        if (!(authCredentials.getNativeCredentials() instanceof String)) {
            throw new AuthenticatorUnavailableException("Configuration Error", "external_session must be combined with a JWT authentication frontend");
        }
        String jwt = (String)authCredentials.getNativeCredentials();
        HttpGet httpGet = new HttpGet("/_searchguard/auth/session/extended");
        httpGet.addHeader("Authorization", "bearer " + jwt);
        return (CompletableFuture)PrivilegedCode.execute(() -> {
            CompletableFuture<AuthCredentials> completableFuture;
            block13: {
                CloseableHttpResponse response = this.executeWithRetry(httpGet, meter);
                try {
                    if (response.getStatusLine().getStatusCode() == 401) {
                        throw new CredentialsException(new AuthcResult.DebugInfo(this.getType(), false, "Failed to authenticate with JWT", (Map)ImmutableMap.of((Object)"response_status", (Object)response.getStatusLine())));
                    }
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new AuthenticatorUnavailableException("Authentication failed", "session cluster is unavailable").details("response_status", (Object)response.getStatusLine(), new Object[0]);
                    }
                    DocNode responseBody = DocNode.parse((Format)Format.JSON).from(response.getEntity().getContent());
                    DocNode user = responseBody.getAsNode("user");
                    if (user == null) {
                        throw new AuthenticatorUnavailableException("Authentication failed", "session cluster returned invalid result").details("response_status", (Object)response.getStatusLine(), new Object[]{"response_body", responseBody.toJsonString()});
                    }
                    String userName = user.getAsString("name");
                    if (userName == null) {
                        throw new AuthenticatorUnavailableException("Authentication failed", "session cluster returned invalid result").details("response_status", (Object)response.getStatusLine(), new Object[]{"response_body", responseBody.toJsonString()});
                    }
                    ImmutableList backendRoles = user.hasNonNull("backend_roles") ? user.getAsListOfStrings("backend_roles") : ImmutableList.empty();
                    ImmutableList searchGuardRoles = user.hasNonNull("search_guard_roles") ? user.getAsListOfStrings("search_guard_roles") : ImmutableList.empty();
                    ImmutableMap attributes = user.hasNonNull("attributes") ? user.getAsNode("attributes").toMap() : ImmutableMap.empty();
                    completableFuture = CompletableFuture.completedFuture(authCredentials.with(AuthCredentials.forUser((String)userName).backendRoles((Collection)backendRoles).searchGuardRoles((Collection)searchGuardRoles).attributes((Map)attributes).build()));
                    if (response == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new AuthenticatorUnavailableException("Authentication failed", "session cluster is unavailable", (Throwable)e);
                    }
                    catch (DocumentParseException e) {
                        throw new AuthenticatorUnavailableException("Authentication failed", "session cluster returned invalid result", (Throwable)e);
                    }
                }
                response.close();
            }
            return completableFuture;
        }, CredentialsException.class, AuthenticatorUnavailableException.class);
    }

    public void destroy() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.warn("Error while closing client", (Throwable)e);
            }
        }
        if (this.connectionManager != null) {
            this.connectionManager.close();
            this.connectionManager = null;
        }
        if (this.idleConnectionMonitorThread != null) {
            this.idleConnectionMonitorThread.interrupt();
            this.idleConnectionMonitorThread = null;
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public String getType() {
        return TYPE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CloseableHttpResponse executeWithRetry(HttpGet httpGet, Meter meter) throws ClientProtocolException, IOException {
        int n;
        int hostCount = this.hosts.size();
        if (hostCount == 1) {
            try (Meter subMeter = meter.detail(((HttpHost)this.hosts.get(0)).toString());){
                CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((HttpHost)this.hosts.get(0), (HttpRequest)httpGet);
                return closeableHttpResponse;
            }
        }
        int first = ThreadLocalRandom.current().nextInt(hostCount);
        for (int i = 0; i < hostCount - 1; ++i) {
            int hostIndex = (i + first) % hostCount;
            try (Meter subMeter = meter.detail(((HttpHost)this.hosts.get(hostIndex)).toString());){
                CloseableHttpResponse response = this.httpClient.execute((HttpHost)this.hosts.get(hostIndex), (HttpRequest)httpGet);
                if (response.getStatusLine().getStatusCode() < 500) {
                    CloseableHttpResponse closeableHttpResponse = response;
                    return closeableHttpResponse;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Got status " + response.getStatusLine() + " while executing " + httpGet + ". Retrying with next host");
                }
                response.close();
                continue;
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Got exception while executing " + httpGet + ". Retrying with next host", (Throwable)e);
            }
        }
        if (first == 0) {
            n = hostCount - 1;
            return this.httpClient.execute((HttpHost)this.hosts.get(n), (HttpRequest)httpGet);
        }
        n = first - 1;
        return this.httpClient.execute((HttpHost)this.hosts.get(n), (HttpRequest)httpGet);
    }
}

